# PYTHON & PASCO: Eksoterm eller endoterm reaksjon
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *

# --------------------------- Importering av data ------------------------------
# Lister for lagring av data
tid = []
temp = []

# Innlesing av data fra PASCO
with open('Temperaturmåling nyco i vann.txt') as file: 
    next(file) # Hopper over overskrift-linjen
    # Løkke over hver linje i datafilen. Hele linjer leses som én tekst.
    for line in file: 
        # Klargjør data for lagring i lister
        line = line.replace(",",".")    # Bytter desimaltegn
        line = line.replace("\n","")    # Fjerner uønskede linjeskift
        line = line.split("\t")         # Splitter streng til liste
        # Tallene i lista står som tekst, konverterer til tall og lagrer
        tid.append(float(line[1]))      # Tidsdata lagres i egen liste
        temp.append(float(line[2]))      # Posisjonsdata lagres i liste

#Finn differeansen mellom siste [-1] og første [0] element
temp_diff = temp[-1]-temp[0] 
#Beregn relativ endring i temperatur (enhet %)
endring = (temp_diff)/temp[0]*100.0

# Skriv ut om reaksjonen er endoterm eller eksoterm. 
# Et spesialtilfelle om endringen er lik null er lagt 
# til for sikkerhets skyld
if average(temp_diff) < 0:
    print("Reaksjonen er endoterm")
elif average(temp_diff) > 0:
    print("Reaksjonen er eksoterm")
else:
    print("Reaksjonen påvirker ikke temperaturen")

# Skriv ut dn relative endringen i temperatur
print("Den faktiske forandringen er ",
    round(temp_diff,1)," grader")
print("Den relative forandringen er ",
    round(endring,1),"%")

# ------------------------ Plotting av resultater ------------------------------
# Data fra PASCO plottes som punkter, regresjon og modell som grafer
# Data plottes i tre paneler over hverandre. 
plot(tid,temp)            # Plotter data 
ylabel("Temp. ($K$)")     # y-akse-tittel i panel 1
xlabel("Tid (s)")         # x-akse-tittel
grid()

# Vis plottet
show() 